
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B1")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B12")

# Set the objective
m.setObjective(9.48*x0 + 7.02*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x0 + 6*x1 >= 38, "cardiovascular_support_min")
m.addConstr(-3*x0 + 5*x1 >= 0, "given_constraint")
m.addConstr(5*x0 + 6*x1 <= 82, "cardiovascular_support_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B1: {x0.x}")
    print(f"Milligrams of Vitamin B12: {x1.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found")
