
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="milligrams_of_vitamin_B1", lb=0)  # Lower bound is 0, assuming non-negative
    x1 = model.addVar(name="milligrams_of_vitamin_B12", lb=0)  # Lower bound is 0, assuming non-negative

    # Objective function: Maximize 9.48x0 + 7.02x1
    model.setObjective(9.48 * x0 + 7.02 * x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5 * x0 + 6 * x1 >= 38, name="cardiovascular_support_index_min")
    model.addConstr(5 * x0 + 6 * x1 <= 82, name="cardiovascular_support_index_max")
    model.addConstr(-3 * x0 + 5 * x1 >= 0, name="linear_constraint")

    # Solve the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B1: {x0.varValue}")
        print(f"Milligrams of vitamin B12: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
