
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
J = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Jean")
B = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bill")

# Objective function: Minimize 3*J^2 + 4*B^2 + J
m.setObjective(3*J**2 + 4*B**2 + J, GRB.MINIMIZE)

# Constraints
m.addConstr(18*J + 23*B >= 75, name="min_computer_competence")
m.addConstr(12*J + 11*B >= 62, name="min_dollar_cost")
m.addConstr(4*J - 8*B >= 0, name="jean_bill_ratio")
m.addConstr(18*J + 23*B <= 89, name="max_computer_competence")
m.addConstr(12*J + 11*B <= 124, name="max_dollar_cost")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by Jean:", J.x)
    print("Hours worked by Bill:", B.x)
else:
    print("No optimal solution found")
