
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
hours_jean = m.addVar(lb=0, name="hours_worked_by_Jean")  # Continuous variable
hours_bill = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours_worked_by_Bill")  # Integer variable

# Objective function
m.setObjective(3 * hours_jean**2 + 4 * hours_bill**2 + hours_jean, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(18 * hours_jean + 23 * hours_bill >= 75, name="min_computer_competence")
m.addConstr(12 * hours_jean + 11 * hours_bill >= 62, name="min_dollar_cost")
m.addConstr(4 * hours_jean - 8 * hours_bill >= 0, name="jean_bill_constraint")
m.addConstr(18 * hours_jean + 23 * hours_bill <= 89, name="max_computer_competence")
m.addConstr(12 * hours_jean + 11 * hours_bill <= 124, name="max_dollar_cost")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Jean: {hours_jean.varValue}")
    print(f"Hours worked by Bill: {hours_bill.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
