
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_B9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B9")
vitamin_B4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B4")
fiber = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fiber")
vitamin_K = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_K")

# Set objective function
m.setObjective(7 * vitamin_B9 + 8 * vitamin_B4 + 7 * fiber + 5 * vitamin_K, gp.GRB.MAXIMIZE)

# Add constraints
kidney_support_index = {"vitamin_B9": 11, "vitamin_B4": 9, "fiber": 11, "vitamin_K": 3}
m.addConstr(kidney_support_index["vitamin_B4"] * vitamin_B4 - fiber >= 0, "c1")
m.addConstr(kidney_support_index["vitamin_B4"] * vitamin_B4 + kidney_support_index["vitamin_K"] * vitamin_K <= 64, "c2")
m.addConstr(kidney_support_index["vitamin_B9"] * vitamin_B9 + kidney_support_index["vitamin_B4"] * vitamin_B4 <= 75, "c3")
m.addConstr(kidney_support_index["vitamin_B9"] * vitamin_B9 + kidney_support_index["fiber"] * fiber <= 49, "c4")
m.addConstr(kidney_support_index["fiber"] * fiber + kidney_support_index["vitamin_K"] * vitamin_K <= 45, "c5")
m.addConstr(kidney_support_index["vitamin_B9"] * vitamin_B9 + kidney_support_index["vitamin_K"] * vitamin_K <= 30, "c6")
m.addConstr(kidney_support_index["vitamin_B9"] * vitamin_B9 + kidney_support_index["vitamin_B4"] * vitamin_B4 + kidney_support_index["fiber"] * fiber + kidney_support_index["vitamin_K"] * vitamin_K <= 30, "c7")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

