
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B9")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B4")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="grams_of_fiber")
x3 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_K")

# Define the objective function
m.setObjective(7*x0 + 8*x1 + 7*x2 + 5*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(-8*x1 + x2 >= 0, name="constraint_1")
m.addConstr(x1 + x3 <= 64, name="constraint_2")
m.addConstr(x0 + x1 <= 75, name="constraint_3")
m.addConstr(x0 + x2 <= 49, name="constraint_4")
m.addConstr(x2 + x3 <= 45, name="constraint_5")
m.addConstr(x0 + x3 <= 30, name="constraint_6")
m.addConstr(x0 + x1 + x2 + x3 <= 30, name="constraint_7")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
else:
    print("No optimal solution found")
