
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
green_beans = m.addVar(vtype=GRB.INTEGER, name="green_beans")
cheeseburgers = m.addVar(vtype=GRB.CONTINUOUS, name="cheeseburgers")

# Set objective function
m.setObjective(8.05 * green_beans**2 + 7.14 * green_beans * cheeseburgers + 7.69 * cheeseburgers**2 + 2.38 * green_beans, GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * green_beans**2 + 4 * cheeseburgers**2 >= 13, "c1")
m.addConstr(3 * green_beans + 4 * cheeseburgers >= 13, "c2")
m.addConstr(-5 * green_beans**2 + 2 * cheeseburgers**2 >= 0, "c3")
m.addConstr(3 * green_beans + 4 * cheeseburgers <= 44, "c0")


# Optimize model
m.optimize()

# Check if a solution was found
if m.status == GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('Green beans:', green_beans.x)
    print('Cheeseburgers:', cheeseburgers.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

