
from gurobipy import *

# Create a new model
m = Model("Optimization_Model")

# Define variables
green_beans = m.addVar(vtype=GRB.INTEGER, name="green_beans")
cheeseburgers = m.addVar(vtype=GRB.CONTINUOUS, name="cheeseburgers")

# Objective function
m.setObjective(8.05 * green_beans**2 + 7.14 * green_beans * cheeseburgers + 7.69 * cheeseburgers**2 + 2.38 * green_beans, GRB.MINIMIZE)

# Constraints
m.addConstr(9 * green_beans + 16 * cheeseburgers >= 13, name="umami_index_squared_min")
m.addConstr(3 * green_beans + 4 * cheeseburgers >= 13, name="umami_index_min")
m.addConstr(-5 * green_beans**2 + 2 * cheeseburgers**2 >= 0, name="green_beans_cheeseburgers_relationship")
m.addConstr(3 * green_beans + 4 * cheeseburgers <= 44, name="umami_index_max")

# Optimizer parameters
m.Params.OutputFlag = 1

# Solve the model
m.optimize()

