
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define variables
green_beans = m.addVar(name="green_beans", vtype=gurobi.GRB.INTEGER)
cheeseburgers = m.addVar(name="cheeseburgers")

# Objective function
m.setObjective(8.05 * green_beans ** 2 + 7.14 * green_beans * cheeseburgers + 7.69 * cheeseburgers ** 2 + 2.38 * green_beans, gurobi.GRB.MINIMIZE)

# Constraints
# 1. Umami index of green beans is 3 (not needed as it's a variable property)
# 2. Umami index of cheeseburgers is 4 (not needed as it's a variable property)
# 3. Total combined umami index from green beans and cheeseburgers squared must be at least 13
m.addConstraint(3 ** 2 * green_beans ** 2 + 4 ** 2 * cheeseburgers ** 2 >= 13, name="umami_squared_min")
# 4. Total combined umami index from green beans and cheeseburgers should be at minimum 13
m.addConstraint(3 * green_beans + 4 * cheeseburgers >= 13, name="umami_min")
# 5. -5 * (green beans)^2 + 2 * (cheeseburgers)^2 >= 0
m.addConstraint(-5 * green_beans ** 2 + 2 * cheeseburgers ** 2 >= 0, name="cheeseburgers_vs_green_beans")
# 6. Total combined umami index from green beans and cheeseburgers has to be at maximum 44
m.addConstraint(3 * green_beans + 4 * cheeseburgers <= 44, name="umami_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Green beans: {green_beans.varValue}")
    print(f"Cheeseburgers: {cheeseburgers.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
