
import gurobi as gp

m = gp.Model("optimization_problem")

pansies = m.addVar(name="pansies", vtype=gp.GRB.INTEGER)
cherry_trees = m.addVar(name="cherry_trees", vtype=gp.GRB.INTEGER)
agave = m.addVar(name="agave", vtype=gp.GRB.INTEGER)
petunias = m.addVar(name="petunias", vtype=gp.GRB.INTEGER)
cucumber_vines = m.addVar(name="cucumber_vines", vtype=gp.GRB.INTEGER)

m.setObjective(5.18 * pansies**2 + 8.58 * pansies * cherry_trees + 9.54 * agave**2 + 7.11 * agave * cucumber_vines + 7.56 * agave, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(pansies * 20 <= 323)
m.addConstr(pansies * 20 + agave * 2 + cucumber_vines * 2 >= 51)
m.addConstr(cherry_trees * 9 + agave * 2 + petunias * 12 >= 51)
m.addConstr(pansies * 14 + cherry_trees * 27 + agave * 2 + petunias * 11 + cucumber_vines * 19 <= 340)
m.addConstr(pansies * 27 + cherry_trees + agave * 9 + petunias * 16 + cucumber_vines * 23 <= 271)
m.addConstr(pansies + cucumber_vines >= 27)
m.addConstr(cherry_trees + agave + cucumber_vines >= 56)
m.addConstr(pansies + agave + petunias >= 56)
m.addConstr(pansies + cherry_trees + agave >= 56)

# Add integer constraints
m.addConstr(pansies >= 0, name="pansies_non_negative")
m.addConstr(cherry_trees >= 0, name="cherry_trees_non_negative")
m.addConstr(agave >= 0, name="agave_non_negative")
m.addConstr(petunias >= 0, name="petunias_non_negative")
m.addConstr(cucumber_vines >= 0, name="cucumber_vines_non_negative")

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Pansies: ", pansies.varValue)
    print("Cherry Trees: ", cherry_trees.varValue)
    print("Agave: ", agave.varValue)
    print("Petunias: ", petunias.varValue)
    print("Cucumber Vines: ", cucumber_vines.varValue)
else:
    print("The problem is infeasible or unbounded.")
