
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    variables = {
        'hours worked by Jean': m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0"),
        'hours worked by Bobby': m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1"),
        'hours worked by Paul': m.addVar(vtype=gp.GRB.INTEGER, name="x2"),
        'hours worked by Ringo': m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3"),
        'hours worked by Peggy': m.addVar(vtype=gp.GRB.CONTINUOUS, name="x4"),
        'hours worked by Dale': m.addVar(vtype=gp.GRB.INTEGER, name="x5")
    }

    # Set objective function
    m.setObjective(2.33 * variables['hours worked by Jean'] + 3.47 * variables['hours worked by Bobby'] + 8.73 * variables['hours worked by Paul'] + 9.74 * variables['hours worked by Ringo'] + 2.58 * variables['hours worked by Peggy'] + 9.88 * variables['hours worked by Dale'], gp.GRB.MAXIMIZE)

    # Resource constraints
    resources = {
        'r0': {'upper_bound': 185, 'coefficients': [11, 12, 2, 14, 1, 7]},
        'r1': {'upper_bound': 263, 'coefficients': [6, 10, 4, 13, 11, 12]}
    }

    for resource, data in resources.items():
        m.addConstr(gp.quicksum(data['coefficients'][i] * variables[list(variables.keys())[i]] for i in range(len(variables))) <= data['upper_bound'], resource)


    # Additional constraints (provided in the prompt)
    constraints = [
        (1,1,0,0,0,0,">=",19), (0,0,0,0,1,1,">=",34), (0,0,1,1,0,0,">=",19), (0,1,0,1,0,0,">=",31), (1,0,1,0,0,0,">=",42), (0,1,0,0,0,1,">=",28), (1,0,0,1,0,0,">=",18), (0,1,1,0,0,0,">=",21)
    ] + [(sum(c[i]*variables[list(variables.keys())[i]] for i in range(6)) >= c[6]) for c in constraints]

    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('\nOptimal Solution Found:\n')
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print('\nObjective Value:', m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('\nModel is infeasible\n')
    else:
        print('\nOptimization ended with status:', m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
