
from gurobipy import Model, GRB

# Create a new model
model = Model("Grocery Optimization")

# Create variables
chicken_breasts = model.addVar(vtype=GRB.CONTINUOUS, name="chicken_breasts")
potatoes = model.addVar(vtype=GRB.CONTINUOUS, name="potatoes")
rotisserie_chickens = model.addVar(vtype=GRB.CONTINUOUS, name="rotisserie_chickens")
bagged_salads = model.addVar(vtype=GRB.CONTINUOUS, name="bagged_salads")
bananas = model.addVar(vtype=GRB.CONTINUOUS, name="bananas")

# Set objective function
model.setObjective(6.84 * chicken_breasts + 8.92 * potatoes + 2.94 * rotisserie_chickens + 8.74 * bagged_salads + 7.66 * bananas, GRB.MINIMIZE)

# Add constraints
model.addConstr(14 * rotisserie_chickens + 2 * bagged_salads >= 36, "c1")
model.addConstr(9 * potatoes + 2 * bagged_salads >= 39, "c2")
model.addConstr(14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas >= 26, "c3")
model.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens >= 26, "c4")
model.addConstr(21 * chicken_breasts + 9 * potatoes + 13 * bananas >= 26, "c5")
model.addConstr(14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas >= 44, "c6")
model.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens >= 44, "c7")
model.addConstr(21 * chicken_breasts + 9 * potatoes + 13 * bananas >= 44, "c8")
model.addConstr(14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas >= 42, "c9")
model.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens >= 42, "c10")
model.addConstr(21 * chicken_breasts + 9 * potatoes + 13 * bananas >= 42, "c11")
model.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas >= 42, "c12")
model.addConstr(-10 * potatoes + 2 * bananas >= 0, "c13")
model.addConstr(10 * potatoes - 10 * rotisserie_chickens >= 0, "c14")
model.addConstr(21 * chicken_breasts + 2 * bagged_salads + 13 * bananas <= 68, "c15")
model.addConstr(14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas <= 168, "c16")
model.addConstr(21 * chicken_breasts + 14 * rotisserie_chickens + 13 * bananas <= 85, "c17")
model.addConstr(21 * chicken_breasts + 9 * potatoes + 13 * bananas <= 160, "c18")
model.addConstr(21 * chicken_breasts + 14 * rotisserie_chickens + 2 * bagged_salads <= 156, "c19")
model.addConstr(9 * potatoes + 14 * rotisserie_chickens + 13 * bananas <= 126, "c20")
model.addConstr(9 * potatoes + 2 * bagged_salads + 13 * bananas <= 78, "c21")
model.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens <= 154, "c22")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

