
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
chicken_breasts = m.addVar(name="chicken_breasts", lb=0)
potatoes = m.addVar(name="potatoes", lb=0)
rotisserie_chickens = m.addVar(name="rotisserie_chickens", lb=0)
bagged_salads = m.addVar(name="bagged_salads", lb=0)
bananas = m.addVar(name="bananas", lb=0)

# Define the objective function
m.setObjective(6.84 * chicken_breasts + 8.92 * potatoes + 2.94 * rotisserie_chickens + 8.74 * bagged_salads + 7.66 * bananas, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(14 * rotisserie_chickens + 2 * bagged_salads >= 36)
m.addConstr(9 * potatoes + 2 * bagged_salads >= 39)
m.addConstr(14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas >= 26)
m.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens >= 26)
m.addConstr(21 * chicken_breasts + 9 * potatoes + 13 * bananas >= 26)
m.addConstr(14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas >= 44)
m.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens >= 44)
m.addConstr(21 * chicken_breasts + 9 * potatoes + 13 * bananas >= 44)
m.addConstr(14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas >= 42)
m.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens >= 42)
m.addConstr(21 * chicken_breasts + 9 * potatoes + 13 * bananas >= 42)
m.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas >= 42)
m.addConstr(-10 * potatoes + 2 * bananas >= 0)
m.addConstr(10 * potatoes - 10 * rotisserie_chickens >= 0)
m.addConstr(21 * chicken_breasts + 2 * bagged_salads + 13 * bananas <= 68)
m.addConstr(14 * rotisserie_chickens + 2 * bagged_salads + 13 * bananas <= 168)
m.addConstr(21 * chicken_breasts + 14 * rotisserie_chickens + 13 * bananas <= 85)
m.addConstr(21 * chicken_breasts + 9 * potatoes + 13 * bananas <= 160)
m.addConstr(21 * chicken_breasts + 14 * rotisserie_chickens + 2 * bagged_salads <= 156)
m.addConstr(9 * potatoes + 14 * rotisserie_chickens + 13 * bananas <= 126)
m.addConstr(9 * potatoes + 2 * bagged_salads + 13 * bananas <= 78)
m.addConstr(21 * chicken_breasts + 9 * potatoes + 14 * rotisserie_chickens <= 154)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Chicken Breasts: ", chicken_breasts.varValue)
    print("Potatoes: ", potatoes.varValue)
    print("Rotisserie Chickens: ", rotisserie_chickens.varValue)
    print("Bagged Salads: ", bagged_salads.varValue)
    print("Bananas: ", bananas.varValue)
else:
    print("The model is infeasible")
