
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
cheeseburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
cantaloupes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cantaloupes")
protein_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein_bars")
blueberry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry_pies")

# Set objective function
m.setObjective(8.78 * cheeseburgers + 9.72 * cantaloupes + 6.84 * protein_bars + 3.94 * blueberry_pies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(12 * cheeseburgers + 1 * cantaloupes + 11 * protein_bars + 12 * blueberry_pies <= 249, "dollar_cost") # Resource constraint
m.addConstr(6 * cheeseburgers + 12 * cantaloupes + 8 * protein_bars + 8 * blueberry_pies <= 231, "grams_of_fat") # Resource constraint
m.addConstr(2 * cheeseburgers + 2 * cantaloupes + 3 * protein_bars + 16 * blueberry_pies <= 98, "grams_of_protein") # Resource constraint

m.addConstr(cantaloupes + protein_bars >= 32, "cost_constraint1")
m.addConstr(cantaloupes + blueberry_pies >= 36, "cost_constraint2")
m.addConstr(cheeseburgers + cantaloupes >= 55, "cost_constraint3")
m.addConstr(cheeseburgers + cantaloupes + protein_bars + blueberry_pies >= 55, "cost_constraint4")

m.addConstr(6 * cheeseburgers + 12 * cantaloupes >= 57, "fat_constraint1")
m.addConstr(8 * protein_bars + 8 * blueberry_pies >= 42, "fat_constraint2")
m.addConstr(6 * cheeseburgers + 8 * protein_bars >= 29, "fat_constraint3")
m.addConstr(6 * cheeseburgers + 12 * cantaloupes + 8 * protein_bars >= 54, "fat_constraint4")
m.addConstr(6 * cheeseburgers + 12 * cantaloupes + 8 * protein_bars + 8 * blueberry_pies >= 54, "fat_constraint5")


m.addConstr(3 * protein_bars + 16 * blueberry_pies >= 20, "protein_constraint1")
m.addConstr(2 * cantaloupes + 3 * protein_bars >= 10, "protein_constraint2")
m.addConstr(2 * cantaloupes + 16 * blueberry_pies >= 24, "protein_constraint3")
m.addConstr(2 * cheeseburgers + 2 * cantaloupes + 3 * protein_bars + 16 * blueberry_pies >= 24, "protein_constraint4")

m.addConstr(-9 * cantaloupes + 10 * blueberry_pies >= 0, "constraint1")
m.addConstr(6 * cheeseburgers - 5 * protein_bars >= 0, "constraint2")
m.addConstr(-9 * cheeseburgers + 7 * blueberry_pies >= 0, "constraint3")

m.addConstr(12 * cheeseburgers + 12 * blueberry_pies <= 117, "cost_constraint5")
m.addConstr(11 * protein_bars + 12 * blueberry_pies <= 181, "cost_constraint6")
m.addConstr(cantaloupes + protein_bars + blueberry_pies <= 69, "cost_constraint7")
m.addConstr(12 * cheeseburgers + cantaloupes + 11 * protein_bars <= 64, "cost_constraint8")

m.addConstr(6 * cheeseburgers + 12 * cantaloupes + 8 * protein_bars <= 230, "fat_constraint6")

m.addConstr(2 * cheeseburgers + 3 * protein_bars <= 82, "protein_constraint5")
m.addConstr(3 * protein_bars + 16 * blueberry_pies <= 39, "protein_constraint6")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

