
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define decision variables (allowing for non-integer values)
cheeseburgers = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cheeseburgers")
cantaloupes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cantaloupes")
protein_bars = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="protein_bars")
blueberry_pies = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="blueberry_pies")

# Objective function: Minimize cost
m.setObjective(8.78 * cheeseburgers + 9.72 * cantaloupes + 6.84 * protein_bars + 3.94 * blueberry_pies, GRB.MINIMIZE)

# Constraints based on the problem description
# Cost constraints
m.addConstr(12 * cheeseburgers <= 249, name="max_cost_cheeseburgers")
m.addConstr(cantaloupes <= 231, name="max_cost_cantaloupes")
m.addConstr(11 * protein_bars + 12 * blueberry_pies <= 181, name="max_cost_protein_bars_and_blueberry_pies")

# Fat constraints
m.addConstr(6 * cheeseburgers + 12 * cantaloupes >= 57, name="min_fat_cheeseburgers_and_cantaloupes")
m.addConstr(8 * protein_bars + 8 * blueberry_pies >= 42, name="min_fat_protein_bars_and_blueberry_pies")
m.addConstr(6 * cheeseburgers + 8 * protein_bars >= 29, name="min_fat_cheeseburgers_and_protein_bars")
m.addConstr(6 * cheeseburgers + 12 * cantaloupes + 8 * protein_bars <= 230, name="max_fat_cheeseburgers_cantaloupes_protein_bars")

# Protein constraints
m.addConstr(3 * protein_bars + 16 * blueberry_pies >= 20, name="min_protein_protein_bars_and_blueberry_pies")
m.addConstr(2 * cantaloupes + 3 * protein_bars >= 10, name="min_protein_cantaloupes_and_protein_bars")
m.addConstr(2 * cantaloupes + 16 * blueberry_pies >= 24, name="min_protein_cantaloupes_and_blueberry_pies")
m.addConstr(2 * cheeseburgers + 2 * cantaloupes + 3 * protein_bars + 16 * blueberry_pies >= 24, name="min_total_protein")

# Additional constraints
m.addConstr(-9 * cantaloupes + 10 * blueberry_pies >= 0, name="cantaloupes_and_blueberry_pies_relation")
m.addConstr(6 * cheeseburgers - 5 * protein_bars >= 0, name="cheeseburgers_and_protein_bars_relation")
m.addConstr(-9 * cheeseburgers + 7 * blueberry_pies >= 0, name="cheeseburgers_and_blueberry_pies_relation")

# Total cost constraints
m.addConstr(12 * cheeseburgers + cantaloupes >= 55, name="min_cost_cheeseburgers_and_cantaloupes")
m.addConstr(cantaloupes + 12 * blueberry_pies >= 36, name="min_cost_cantaloupes_and_blueberry_pies")
m.addConstr(11 * protein_bars + cantaloupes + 12 * blueberry_pies <= 69, name="max_cost_protein_bars_cantaloupes_blueberry_pies")

# Optimize the model
m.optimize()

# Print results if an optimal solution is found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for var in m.getVars():
        print(f"{var.varName}: {var.x}")
else:
    print("No optimal solution found")
