
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
chicken_breasts = m.addVar(vtype=GRB.INTEGER, name="chicken_breasts")
steaks = m.addVar(vtype=GRB.INTEGER, name="steaks")
lemons = m.addVar(vtype=GRB.INTEGER, name="lemons")

# Set objective function
m.setObjective(chicken_breasts**2 + 8*steaks**2 + 5*steaks*lemons + 3*lemons**2 + 5*chicken_breasts, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*steaks**2 + 3*lemons**2 >= 19, "umami_constraint1")
m.addConstr(chicken_breasts + 3*lemons >= 11, "umami_constraint2")
m.addConstr(8*chicken_breasts**2 - 3*lemons**2 >= 0, "constraint3")
m.addConstr(chicken_breasts + 6*steaks <= 62, "umami_constraint4")
m.addConstr(6*steaks + 3*lemons <= 27, "umami_constraint5")
m.addConstr(chicken_breasts + 3*lemons <= 32, "umami_constraint6")
m.addConstr(chicken_breasts + 6*steaks + 3*lemons <= 32, "umami_constraint7")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('chicken_breasts:', chicken_breasts.x)
    print('steaks:', steaks.x)
    print('lemons:', lemons.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

