
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
chicken_breasts = m.addVar(vtype=GRB.INTEGER, name="chicken_breasts")
steaks = m.addVar(vtype=GRB.INTEGER, name="steaks")
lemons = m.addVar(vtype=GRB.INTEGER, name="lemons")

# Objective function
m.setObjective(1 * chicken_breasts**2 + 8 * steaks**2 + 5 * steaks * lemons + 3 * lemons**2 + 5 * chicken_breasts, GRB.MAXIMIZE)

# Constraints
m.addConstr(steaks**2 + lemons**2 >= 19)  # Minimum combined umami index from steaks and lemons squared
m.addConstr(chicken_breasts + lemons >= 11)  # Total combined umami index from chicken breasts and lemons at least 11
m.addConstr(8 * chicken_breasts**2 - 3 * lemons**2 >= 0)  # Constraint on chicken breasts and lemons squared
m.addConstr(chicken_breasts + 6*steaks <= 62)  # Total combined umami index from chicken breasts plus steaks less than or equal to 62
m.addConstr(6*steaks + 3*lemons <= 27)  # Total combined umami index from steaks and lemons at most 27
m.addConstr(chicken_breasts + 3*lemons <= 32)  # Total combined umami index from chicken breasts and lemons at most 32
m.addConstr(chicken_breasts + 6*steaks + 3*lemons <= 70)  # Total combined umami index less than or equal to upper bound

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Chicken Breasts: {chicken_breasts.x}")
    print(f"Steaks: {steaks.x}")
    print(f"Lemons: {lemons.x}")
else:
    print("No optimal solution found.")
