
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    chicken_breasts = model.addVar(name="chicken_breasts", vtype=gurobi.GRB.INTEGER)
    steaks = model.addVar(name="steaks", vtype=gurobi.GRB.INTEGER)
    lemons = model.addVar(name="lemons", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(1 * chicken_breasts**2 + 8 * steaks**2 + 5 * steaks * lemons + 3 * lemons**2 + 5 * chicken_breasts, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(steaks**2 + lemons**2 >= 19)
    model.addConstr(chicken_breasts + 3 * lemons >= 11)
    model.addConstr(8 * chicken_breasts**2 - 3 * lemons**2 >= 0)
    model.addConstr(chicken_breasts + 6 * steaks <= 62)
    model.addConstr(6 * steaks + 3 * lemons <= 27)
    model.addConstr(chicken_breasts + 3 * lemons <= 32)
    model.addConstr(chicken_breasts + 6 * steaks + 3 * lemons <= 32)

    # Umami index upper bounds for variables (not necessary as already defined in constraints)
    # model.addConstr(chicken_breasts <= 70)  # Not directly needed, part of other constraints
    # model.addConstr(6 * steaks <= 70)
    # model.addConstr(3 * lemons <= 70)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Chicken Breasts: {chicken_breasts.varValue}")
        print(f"Steaks: {steaks.varValue}")
        print(f"Lemons: {lemons.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
