
import gurobipy as gp

# Create a new model
m = gp.Model("portability_optimization")

# Create variables
lightbulbs = m.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")
rubber_gloves = m.addVar(vtype=gp.GRB.INTEGER, name="rubber_gloves")
napkins = m.addVar(vtype=gp.GRB.INTEGER, name="napkins")
diapers = m.addVar(vtype=gp.GRB.INTEGER, name="diapers")
cookies = m.addVar(vtype=gp.GRB.INTEGER, name="cookies")

# Set objective function
m.setObjective(9 * lightbulbs + 8 * rubber_gloves + 9 * napkins + 4 * diapers + 1 * cookies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(25 * rubber_gloves + 2 * napkins >= 77, "c1")
m.addConstr(7 * lightbulbs + 2 * cookies >= 50, "c2")
m.addConstr(25 * rubber_gloves + 2 * cookies >= 41, "c3")
m.addConstr(7 * lightbulbs + 25 * rubber_gloves >= 63, "c4")
m.addConstr(7 * lightbulbs + 19 * diapers >= 101, "c5")
m.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * cookies >= 66, "c6")
m.addConstr(25 * rubber_gloves + 2 * napkins + 19 * diapers >= 66, "c7")
m.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * cookies >= 88, "c8")
m.addConstr(25 * rubber_gloves + 2 * napkins + 19 * diapers >= 88, "c9")
m.addConstr(19 * diapers + 2 * cookies <= 335, "c10")
m.addConstr(25 * rubber_gloves + 2 * napkins <= 292, "c11")
m.addConstr(25 * rubber_gloves + 19 * diapers <= 451, "c12")
m.addConstr(7 * lightbulbs + 19 * diapers <= 273, "c13")
m.addConstr(7 * lightbulbs + 2 * napkins <= 249, "c14")
m.addConstr(2 * napkins + 19 * diapers <= 459, "c15")
m.addConstr(7 * lightbulbs + 25 * rubber_gloves <= 122, "c16")
m.addConstr(25 * rubber_gloves + 2 * cookies <= 389, "c17")
m.addConstr(7 * lightbulbs + 2 * cookies <= 388, "c18")
m.addConstr(7 * lightbulbs + 2 * napkins + 2 * cookies <= 428, "c19")
m.addConstr(25 * rubber_gloves + 2 * napkins + 19 * diapers <= 453, "c20")
m.addConstr(25 * rubber_gloves + 19 * diapers + 2 * cookies <= 442, "c21")
m.addConstr(7 * lightbulbs + 19 * diapers + 2 * cookies <= 364, "c22")
m.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * cookies <= 371, "c23")
m.addConstr(7 * lightbulbs + 2 * napkins + 19 * diapers <= 419, "c24")
m.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * napkins <= 422, "c25")
m.addConstr(7 * lightbulbs + 25 * rubber_gloves + 19 * diapers <= 368, "c26")
m.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * napkins + 19 * diapers + 2 * cookies <= 368, "c27")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

