
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
lightbulbs = m.addVar(name="lightbulbs", vtype=gp.GRB.INTEGER)
rubber_gloves = m.addVar(name="rubber_gloves", vtype=gp.GRB.INTEGER)
packs_of_napkins = m.addVar(name="packs_of_napkins", vtype=gp.GRB.INTEGER)
diapers = m.addVar(name="diapers", vtype=gp.GRB.INTEGER)
cookies = m.addVar(name="cookies", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(9 * lightbulbs + 8 * rubber_gloves + 9 * packs_of_napkins + 4 * diapers + cookies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * packs_of_napkins + 19 * diapers + 2 * cookies <= 578)
m.addConstr(25 * rubber_gloves + 2 * packs_of_napkins >= 77)
m.addConstr(7 * lightbulbs + 2 * cookies >= 50)
m.addConstr(25 * rubber_gloves + 2 * cookies >= 41)
m.addConstr(7 * lightbulbs + 25 * rubber_gloves >= 63)
m.addConstr(7 * lightbulbs + 19 * diapers >= 101)
m.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * cookies >= 66)
m.addConstr(25 * rubber_gloves + 2 * packs_of_napkins + 19 * diapers >= 66)
m.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * cookies >= 88)
m.addConstr(25 * rubber_gloves + 2 * packs_of_napkins + 19 * diapers >= 88)
m.addConstr(19 * diapers + 2 * cookies <= 335)
m.addConstr(25 * rubber_gloves + 2 * packs_of_napkins <= 292)
m.addConstr(25 * rubber_gloves + 19 * diapers <= 451)
m.addConstr(7 * lightbulbs + 19 * diapers <= 273)
m.addConstr(7 * lightbulbs + 2 * packs_of_napkins <= 249)
m.addConstr(2 * packs_of_napkins + 19 * diapers <= 459)
m.addConstr(7 * lightbulbs + 25 * rubber_gloves <= 122)
m.addConstr(25 * rubber_gloves + 2 * cookies <= 389)
m.addConstr(7 * lightbulbs + 2 * cookies <= 388)
m.addConstr(7 * lightbulbs + 2 * packs_of_napkins + 2 * cookies <= 428)
m.addConstr(25 * rubber_gloves + 2 * packs_of_napkins + 19 * diapers <= 453)
m.addConstr(25 * rubber_gloves + 19 * diapers + 2 * cookies <= 442)
m.addConstr(7 * lightbulbs + 19 * diapers + 2 * cookies <= 364)
m.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * cookies <= 371)
m.addConstr(7 * lightbulbs + 2 * packs_of_napkins + 19 * diapers <= 419)
m.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * packs_of_napkins <= 422)
m.addConstr(7 * lightbulbs + 25 * rubber_gloves + 19 * diapers <= 368)
m.addConstr(7 * lightbulbs + 25 * rubber_gloves + 2 * packs_of_napkins + 19 * diapers + 2 * cookies <= 368)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Lightbulbs: {lightbulbs.varValue}")
    print(f"Rubber Gloves: {rubber_gloves.varValue}")
    print(f"Packs of Napkins: {packs_of_napkins.varValue}")
    print(f"Diapers: {diapers.varValue}")
    print(f"Cookies: {cookies.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
