
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
milkshakes = m.addVar(lb=0, name="milkshakes")
oreos = m.addVar(lb=0, name="oreos")
pasta = m.addVar(lb=0, name="bowls_of_pasta")
apple_pies = m.addVar(lb=0, name="apple_pies")

# Set objective function
m.setObjective(9 * milkshakes + 4 * oreos + 9 * pasta + 5 * apple_pies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20.74 * pasta + 14.49 * apple_pies >= 87, "calcium_constraint1")
m.addConstr(13.58 * oreos + 14.49 * apple_pies >= 68, "calcium_constraint2")
m.addConstr(23.23 * milkshakes + 20.74 * pasta >= 104, "calcium_constraint3")
m.addConstr(23.23 * milkshakes + 13.58 * oreos + 14.49 * apple_pies >= 69, "calcium_constraint4")
m.addConstr(10.41 * pasta + 23.66 * apple_pies >= 16, "sourness_constraint1")
m.addConstr(13.58 * oreos + 20.74 * pasta <= 277, "calcium_constraint5")
m.addConstr(23.23 * milkshakes + 13.58 * oreos <= 387, "calcium_constraint6")
m.addConstr(23.23 * milkshakes + 20.74 * pasta <= 295, "calcium_constraint7")
m.addConstr(20.74 * pasta + 14.49 * apple_pies <= 137, "calcium_constraint8")
m.addConstr(23.23 * milkshakes + 13.58 * oreos + 14.49 * apple_pies <= 331, "calcium_constraint9")
m.addConstr(23.23 * milkshakes + 13.58 * oreos + 20.74 * pasta <= 256, "calcium_constraint10")
m.addConstr(23.23 * milkshakes + 13.58 * oreos + 20.74 * pasta + 14.49 * apple_pies <= 256, "calcium_constraint11")
m.addConstr(20.53 * milkshakes + 10.41 * pasta <= 68, "sourness_constraint2")
m.addConstr(11.23 * oreos + 23.66 * apple_pies <= 107, "sourness_constraint3")
m.addConstr(10.41 * pasta + 23.66 * apple_pies <= 50, "sourness_constraint4")
m.addConstr(20.53 * milkshakes + 23.66 * apple_pies <= 133, "sourness_constraint5")
m.addConstr(11.23 * oreos + 10.41 * pasta + 23.66 * apple_pies <= 61, "sourness_constraint6")
m.addConstr(20.53 * milkshakes + 11.23 * oreos + 10.41 * pasta <= 143, "sourness_constraint7")
m.addConstr(20.53 * milkshakes + 11.23 * oreos + 23.66 * apple_pies <= 157, "sourness_constraint8")
m.addConstr(20.53 * milkshakes + 11.23 * oreos + 10.41 * pasta + 23.66 * apple_pies <= 157, "sourness_constraint9")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

