
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
milkshakes = m.addVar(name="milkshakes", lb=0)
oreos = m.addVar(name="oreos", lb=0)
bowls_of_pasta = m.addVar(name="bowls_of_pasta", lb=0)
apple_pies = m.addVar(name="apple_pies", lb=0)

# Define the objective function
m.setObjective(9 * milkshakes + 4 * oreos + 9 * bowls_of_pasta + 5 * apple_pies, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(23.23 * milkshakes + 13.58 * oreos + 20.74 * bowls_of_pasta + 14.49 * apple_pies <= 446)
m.addConstr(20.53 * milkshakes + 11.23 * oreos + 10.41 * bowls_of_pasta + 23.66 * apple_pies <= 184)

m.addConstr(20.74 * bowls_of_pasta + 14.49 * apple_pies >= 87)
m.addConstr(13.58 * oreos + 14.49 * apple_pies >= 68)
m.addConstr(23.23 * milkshakes + 20.74 * bowls_of_pasta >= 104)
m.addConstr(23.23 * milkshakes + 13.58 * oreos + 14.49 * apple_pies >= 69)

m.addConstr(10.41 * bowls_of_pasta + 23.66 * apple_pies >= 16)
m.addConstr(13.58 * oreos + 20.74 * bowls_of_pasta <= 277)
m.addConstr(23.23 * milkshakes + 13.58 * oreos <= 387)
m.addConstr(23.23 * milkshakes + 20.74 * bowls_of_pasta <= 295)
m.addConstr(20.74 * bowls_of_pasta + 14.49 * apple_pies <= 137)
m.addConstr(23.23 * milkshakes + 13.58 * oreos + 14.49 * apple_pies <= 331)
m.addConstr(23.23 * milkshakes + 13.58 * oreos + 20.74 * bowls_of_pasta <= 256)
m.addConstr(23.23 * milkshakes + 13.58 * oreos + 20.74 * bowls_of_pasta + 14.49 * apple_pies <= 256)

m.addConstr(20.53 * milkshakes + 10.41 * bowls_of_pasta <= 68)
m.addConstr(11.23 * oreos + 23.66 * apple_pies <= 107)
m.addConstr(10.41 * bowls_of_pasta + 23.66 * apple_pies <= 50)
m.addConstr(20.53 * milkshakes + 23.66 * apple_pies <= 133)
m.addConstr(11.23 * oreos + 10.41 * bowls_of_pasta + 23.66 * apple_pies <= 61)
m.addConstr(20.53 * milkshakes + 11.23 * oreos + 10.41 * bowls_of_pasta <= 143)
m.addConstr(20.53 * milkshakes + 11.23 * oreos + 23.66 * apple_pies <= 157)
m.addConstr(20.53 * milkshakes + 11.23 * oreos + 10.41 * bowls_of_pasta + 23.66 * apple_pies <= 157)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Milkshakes: ", milkshakes.varValue)
    print("Oreos: ", oreos.varValue)
    print("Bowls of pasta: ", bowls_of_pasta.varValue)
    print("Apple pies: ", apple_pies.varValue)
else:
    print("The model is infeasible")
