
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
oreos = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oreos")
kiwis = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kiwis")
pizza = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pizza")

# Set objective function
model.setObjective(8 * oreos + 8 * kiwis + 7 * pizza, GRB.MINIMIZE)

# Add constraints
model.addConstr(oreos + pizza >= 61, "c1")
model.addConstr(oreos + kiwis >= 90, "c2")
model.addConstr(oreos + kiwis + pizza >= 74, "c3")
model.addConstr(7 * kiwis + 6 * pizza >= 59, "c4")
model.addConstr(22 * oreos + 7 * kiwis + 6 * pizza >= 59, "c5")
model.addConstr(-8 * kiwis + 7 * pizza >= 0, "c6")
model.addConstr(3 * oreos - 4 * kiwis >= 0, "c7")
model.addConstr(-4 * oreos + 5 * pizza >= 0, "c8")
model.addConstr(23 * kiwis + 12 * pizza <= 170, "c9")
model.addConstr(oreos + 23*kiwis <= 358, "c10")
model.addConstr(22 * oreos + 6 * pizza <= 115, "c11")
model.addConstr(oreos + 23*kiwis + 12*pizza <= 429, "c12")
model.addConstr(22*oreos + 7*kiwis + 6*pizza <= 316, "c13")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Oreos:', oreos.x)
    print('Kiwis:', kiwis.x)
    print('Pizza:', pizza.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)
