
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
oreos = m.addVar(name="oreos", lb=0)  # No lower bound specified, assuming 0
kiwis = m.addVar(name="kiwis", lb=0)  # No lower bound specified, assuming 0
slices_of_pizza = m.addVar(name="slices_of_pizza", lb=0)  # No lower bound specified, assuming 0

# Objective function
m.setObjective(8 * oreos + 8 * kiwis + 7 * slices_of_pizza, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(oreos + 12 * slices_of_pizza >= 61, name="fiber_oreos_pizza")
m.addConstr(oreos + 23 * kiwis >= 90, name="fiber_oreos_kiwis")
m.addConstr(oreos + 23 * kiwis + 12 * slices_of_pizza >= 74, name="fiber_all")
m.addConstr(7 * kiwis + 6 * slices_of_pizza >= 59, name="sourness_kiwis_pizza")
m.addConstr(22 * oreos + 7 * kiwis + 6 * slices_of_pizza >= 59, name="sourness_all")
m.addConstr(-8 * kiwis + 7 * slices_of_pizza >= 0, name="kiwis_pizza_tradeoff")
m.addConstr(3 * oreos - 4 * kiwis >= 0, name="oreos_kiwis_tradeoff")
m.addConstr(-4 * oreos + 5 * slices_of_pizza >= 0, name="oreos_pizza_tradeoff")
m.addConstr(23 * kiwis + 12 * slices_of_pizza <= 170, name="fiber_kiwis_pizza_limit")
m.addConstr(oreos + 23 * kiwis <= 358, name="fiber_oreos_kiwis_limit")
m.addConstr(22 * oreos + 6 * slices_of_pizza <= 115, name="sourness_oreos_pizza_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Oreos: ", oreos.varValue)
    print("Kiwis: ", kiwis.varValue)
    print("Slices of Pizza: ", slices_of_pizza.varValue)
else:
    print("The model is infeasible")
