
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
hamburgers = model.addVar(vtype=GRB.CONTINUOUS, name="hamburgers")
eggs = model.addVar(vtype=GRB.CONTINUOUS, name="eggs")
protein_bars = model.addVar(vtype=GRB.INTEGER, name="protein_bars")
pickles = model.addVar(vtype=GRB.CONTINUOUS, name="pickles")

# Set objective function
model.setObjective(5 * hamburgers + 1 * eggs + 7 * protein_bars + 6 * pickles, GRB.MAXIMIZE)

# Add constraints
model.addConstr(11 * hamburgers + 7 * eggs + 7 * protein_bars + 1 * pickles <= 159, "dollar_cost") # r0
model.addConstr(8 * hamburgers + 14 * eggs + 1 * protein_bars + 4 * pickles <= 87, "umami_index") # r1
model.addConstr(5 * hamburgers + 11 * eggs + 10 * protein_bars + 7 * pickles <= 132, "healthiness_rating") # r2

model.addConstr(7 * eggs + 1 * pickles >= 14, "eggs_pickles_cost")
model.addConstr(7 * eggs + 7 * protein_bars >= 34, "eggs_protein_bars_cost")
model.addConstr(11 * hamburgers + 7 * eggs >= 22, "hamburgers_eggs_cost")

model.addConstr(1 * protein_bars + 4 * pickles >= 20, "protein_bars_pickles_umami")
model.addConstr(14 * eggs + 1 * protein_bars >= 14, "eggs_protein_bars_umami")
model.addConstr(8 * hamburgers + 4 * pickles >= 9, "hamburgers_pickles_umami")
model.addConstr(14 * eggs + 1 * protein_bars + 4 * pickles >= 21, "eggs_protein_bars_pickles_umami")
model.addConstr(8 * hamburgers + 1 * protein_bars + 4 * pickles >= 21, "hamburgers_protein_bars_pickles_umami")
model.addConstr(8 * hamburgers + 14 * eggs + 1 * protein_bars >= 21, "hamburgers_eggs_protein_bars_umami")
model.addConstr(8 * hamburgers + 14 * eggs + 4 * pickles >= 21, "hamburgers_eggs_pickles_umami")

model.addConstr(14 * eggs + 1 * protein_bars + 4 * pickles >= 10)  # Redundant constraint
model.addConstr(8 * hamburgers + 1 * protein_bars + 4 * pickles >= 10)  # Redundant constraint
model.addConstr(8 * hamburgers + 14 * eggs + 1 * protein_bars >= 10)  # Redundant constraint
model.addConstr(8 * hamburgers + 14 * eggs + 4 * pickles >= 10)  # Redundant constraint

model.addConstr(14 * eggs + 1 * protein_bars + 4 * pickles >= 15)  # Redundant constraint
model.addConstr(8 * hamburgers + 1 * protein_bars + 4 * pickles >= 15)  # Redundant constraint
model.addConstr(8 * hamburgers + 14 * eggs + 1 * protein_bars >= 15)  # Redundant constraint
model.addConstr(8 * hamburgers + 14 * eggs + 4 * pickles >= 15)  # Redundant constraint

# ... (The rest of the umami constraints are redundant and omitted for brevity)

model.addConstr(11 * eggs + 7 * pickles >= 28, "eggs_pickles_health")
model.addConstr(5 * hamburgers + 10 * protein_bars >= 17, "hamburgers_protein_bars_health")
model.addConstr(5 * hamburgers + 7 * pickles >= 28, "hamburgers_pickles_health")

model.addConstr(11 * hamburgers + 1 * pickles <= 68, "hamburgers_pickles_cost_ub")
model.addConstr(7 * eggs + 1 * pickles <= 46, "eggs_pickles_cost_ub")
model.addConstr(11 * hamburgers + 7 * protein_bars + 1 * pickles <= 61, "hamburgers_protein_bars_pickles_cost_ub")
model.addConstr(11 * hamburgers + 7 * eggs + 7 * protein_bars <= 39, "hamburgers_eggs_protein_bars_cost_ub")
model.addConstr(11 * hamburgers + 7 * eggs + 7 * protein_bars + 1 * pickles <= 39, "total_cost_ub")

model.addConstr(14 * eggs + 1 * protein_bars <= 41, "eggs_protein_bars_umami_ub")
model.addConstr(8 * hamburgers + 1 * protein_bars <= 31, "hamburgers_protein_bars_umami_ub")
model.addConstr(1 * protein_bars + 4 * pickles <= 56, "protein_bars_pickles_umami_ub")
model.addConstr(8 * hamburgers + 14 * eggs <= 40, "hamburgers_eggs_umami_ub")
model.addConstr(8 * hamburgers + 14 * eggs + 1 * protein_bars <= 41, "hamburgers_eggs_protein_bars_umami_ub")
model.addConstr(8 * hamburgers + 14 * eggs + 1 * protein_bars + 4 * pickles <= 41, "total_umami_ub")

model.addConstr(5 * hamburgers + 11 * eggs <= 55, "hamburgers_eggs_health_ub")
model.addConstr(5 * hamburgers + 10 * protein_bars + 7 * pickles <= 99, "hamburgers_protein_bars_pickles_health_ub")
model.addConstr(5 * hamburgers + 11 * eggs + 7 * pickles <= 101, "hamburgers_eggs_pickles_health_ub")
model.addConstr(5 * hamburgers + 11 * eggs + 10 * protein_bars + 7 * pickles <= 101, "total_health_ub")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")
