
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
napkins = model.addVar(vtype=GRB.INTEGER, name="napkins")
candles = model.addVar(vtype=GRB.INTEGER, name="candles")
lightbulbs = model.addVar(vtype=GRB.INTEGER, name="lightbulbs")

# Set objective function
model.setObjective(8 * napkins + 7 * candles + 3 * lightbulbs, GRB.MINIMIZE)

# Add constraints
model.addConstr(8 * napkins + 8 * candles >= 19, "c1")
model.addConstr(8 * candles + 3 * lightbulbs >= 17, "c2")
model.addConstr(8 * napkins + 8 * candles + 3 * lightbulbs >= 17, "c3")
model.addConstr(2 * candles + 10 * lightbulbs >= 17, "c4")
model.addConstr(9 * napkins + 2 * candles + 10 * lightbulbs >= 15, "c5")
model.addConstr(9 * napkins + 2 * candles + 10 * lightbulbs >= 15, "c6")  # Redundant constraint
model.addConstr(2 * napkins + 5 * candles >= 11, "c7")
model.addConstr(2 * napkins + 6 * lightbulbs >= 8, "c8")
model.addConstr(2 * napkins + 5 * candles + 6 * lightbulbs >= 22, "c9")
model.addConstr(2 * napkins + 5 * candles + 6 * lightbulbs >= 22, "c10") # Redundant constraint
model.addConstr(-7 * napkins + 8 * lightbulbs >= 0, "c11")
model.addConstr(-9 * candles + 9 * lightbulbs >= 0, "c12")
model.addConstr(2 * candles + 10 * lightbulbs <= 75, "c13")
model.addConstr(9 * napkins + 2 * candles <= 60, "c14")
model.addConstr(2 * napkins + 5 * candles + 6 * lightbulbs <= 42, "c15")


# Resource Constraints (given in the context)
model.addConstr(8 * napkins + 8 * candles + 3 * lightbulbs <= 58, "r0")
model.addConstr(9 * napkins + 2 * candles + 10 * lightbulbs <= 75, "r1")
model.addConstr(2 * napkins + 5 * candles + 6 * lightbulbs <= 67, "r2")



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('napkins:', napkins.x)
    print('candles:', candles.x)
    print('lightbulbs:', lightbulbs.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)

