
import gurobipy as gp

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")
b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="b12")

# Set objective function
m.setObjective(9 * iron + 2 * b12, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9 * iron + 8 * b12 >= 18, "cognitive_lower")
m.addConstr(6 * iron + 7 * b12 >= 34, "energy_lower")
m.addConstr(14 * iron + 8 * b12 >= 17, "cardio_lower")
m.addConstr(13 * iron + 12 * b12 >= 68, "immune_lower")

m.addConstr(3 * iron - 3 * b12 >= 0, "iron_b12_ratio")

m.addConstr(9 * iron + 8 * b12 <= 30, "cognitive_upper")
m.addConstr(6 * iron + 7 * b12 <= 108, "energy_upper")
m.addConstr(14 * iron + 8 * b12 <= 38, "cardio_upper")
m.addConstr(13 * iron + 12 * b12 <= 140, "immune_upper")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Iron: %g' % iron.x)
    print('B12: %g' % b12.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

