
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Create variables
x0 = m.addVar(lb=0, name="milligrams_of_iron")  # Milligrams of iron
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B12")  # Milligrams of vitamin B12

# Set the objective function
m.setObjective(9*x0 + 2*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(9*x0 + 8*x1 >= 18, "cognitive_performance_index_min")
m.addConstr(9*x0 + 8*x1 <= 30, "cognitive_performance_index_max")
m.addConstr(6*x0 + 7*x1 >= 34, "energy_stability_index_min")
m.addConstr(6*x0 + 7*x1 <= 108, "energy_stability_index_max")
m.addConstr(14*x0 + 8*x1 >= 17, "cardiovascular_support_index_min")
m.addConstr(14*x0 + 8*x1 <= 38, "cardiovascular_support_index_max")
m.addConstr(13*x0 + 12*x1 >= 68, "immune_support_index_min")
m.addConstr(13*x0 + 12*x1 <= 140, "immune_support_index_max")
m.addConstr(3*x0 - 3*x1 >= 0, "additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of iron: {x0.x}")
    print(f"Milligrams of vitamin B12: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
