
import gurobi

def optimize_nutrition():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    iron = model.addVar(name="iron", lb=0)  # Milligrams of iron
    vitamin_b12 = model.addVar(name="vitamin_b12", lb=0)  # Milligrams of vitamin B12

    # Objective function: Maximize 9 * iron + 2 * vitamin_b12
    model.setObjective(9 * iron + 2 * vitamin_b12, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Individual contributions
    r0_iron = 9
    r1_iron = 6
    r2_iron = 14
    r3_iron = 13
    r0_b12 = 8
    r1_b12 = 7
    r2_b12 = 8
    r3_b12 = 12

    # Combined index constraints
    model.addConstraint(r0_iron * iron + r0_b12 * vitamin_b12 >= 18, name="cognitive_performance_min")
    model.addConstraint(r0_iron * iron + r0_b12 * vitamin_b12 <= 30, name="cognitive_performance_max")

    model.addConstraint(r1_iron * iron + r1_b12 * vitamin_b12 >= 34, name="energy_stability_min")
    model.addConstraint(r1_iron * iron + r1_b12 * vitamin_b12 <= 108, name="energy_stability_max")

    model.addConstraint(r2_iron * iron + r2_b12 * vitamin_b12 >= 17, name="cardiovascular_support_min")
    model.addConstraint(r2_iron * iron + r2_b12 * vitamin_b12 <= 38, name="cardiovascular_support_max")

    model.addConstraint(r3_iron * iron + r3_b12 * vitamin_b12 >= 68, name="immune_support_min")
    model.addConstraint(r3_iron * iron + r3_b12 * vitamin_b12 <= 140, name="immune_support_max")

    # Other constraints
    model.addConstraint(3 * iron - 3 * vitamin_b12 >= 0, name="balance_constraint")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Iron: {iron.varValue} mg")
        print(f"Vitamin B12: {vitamin_b12.varValue} mg")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_nutrition()
