
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
oreos = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oreos")
cheeseburgers = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cheeseburgers")
lemons = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lemons")

# Set objective function
model.setObjective(8 * oreos + 9 * cheeseburgers + 9 * lemons, GRB.MAXIMIZE)

# Add constraints
model.addConstr(9 * oreos + 19 * lemons >= 23, "sourness_oreos_lemons")
model.addConstr(7 * cheeseburgers + 1 * lemons >= 15, "fiber_cheeseburgers_lemons_min")
model.addConstr(7 * cheeseburgers + 19 * lemons <= 79, "sourness_cheeseburgers_lemons")
model.addConstr(9 * oreos + 7 * cheeseburgers <= 120, "sourness_oreos_cheeseburgers")
model.addConstr(9 * oreos + 7 * cheeseburgers + 19 * lemons <= 120, "sourness_total")
model.addConstr(1 * oreos + 7 * cheeseburgers <= 95, "fiber_oreos_cheeseburgers")
model.addConstr(7 * cheeseburgers + 1 * lemons <= 35, "fiber_cheeseburgers_lemons_max")
model.addConstr(1 * oreos + 7 * cheeseburgers + 1 * lemons <= 35, "fiber_total")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('oreos:', oreos.x)
    print('cheeseburgers:', cheeseburgers.x)
    print('lemons:', lemons.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization ended with status {model.status}")

