
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
oreos = m.addVar(name="oreos", lb=0)  # Non-negative
cheeseburgers = m.addVar(name="cheeseburgers", lb=0)  # Non-negative
lemons = m.addVar(name="lemons", lb=0)  # Non-negative

# Objective function
m.setObjective(8 * oreos + 9 * cheeseburgers + 9 * lemons, gp.GRB.MAXIMIZE)

# Constraints
# 1. Sourness index from oreos and lemons >= 23
m.addConstraint(9 * oreos + 19 * lemons >= 23, name="sourness_oreos_lemons")

# 2. Sourness index from cheeseburgers and lemons <= 79
m.addConstraint(7 * cheeseburgers + 19 * lemons <= 79, name="sourness_cheeseburgers_lemons")

# 3. Sourness index from oreos and cheeseburgers <= 120
m.addConstraint(9 * oreos + 7 * cheeseburgers <= 120, name="sourness_oreos_cheeseburgers")

# 4. Total sourness index <= 120
m.addConstraint(9 * oreos + 7 * cheeseburgers + 19 * lemons <= 120, name="total_sourness")

# 5. Grams of fiber from cheeseburgers and lemons >= 15
m.addConstraint(7 * cheeseburgers + lemons >= 15, name="fiber_cheeseburgers_lemons")

# 6. Grams of fiber from oreos and cheeseburgers <= 95
m.addConstraint(oreos + 7 * cheeseburgers <= 95, name="fiber_oreos_cheeseburgers")

# 7. Grams of fiber from cheeseburgers and lemons <= 35
m.addConstraint(7 * cheeseburgers + lemons <= 35, name="fiber_cheeseburgers_lemons_max")

# 8. Total grams of fiber <= 35
m.addConstraint(oreos + 7 * cheeseburgers + lemons <= 35, name="total_fiber")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Oreos: ", oreos.varValue)
    print("Cheeseburgers: ", cheeseburgers.varValue)
    print("Lemons: ", lemons.varValue)
else:
    print("The model is infeasible")
