
from gurobipy import Model, GRB

# Create a new model
m = Model("work_optimization")

# Create variables
bobby_hours = m.addVar(vtype=GRB.INTEGER, name="bobby_hours")
bill_hours = m.addVar(vtype=GRB.INTEGER, name="bill_hours")

# Set objective function
m.setObjective(5 * bobby_hours + 7 * bill_hours, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14.16 * bobby_hours + 5.77 * bill_hours >= 8, "combined_quality_min")
m.addConstr(-4 * bobby_hours + 5 * bill_hours >= 0, "work_balance")
m.addConstr(14.16 * bobby_hours + 5.77 * bill_hours <= 39, "combined_quality_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Bobby's hours: {bobby_hours.x}")
    print(f"  Bill's hours: {bill_hours.x}")
    print(f"  Objective value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

