
from gurobipy import *

# Create a model
m = Model("Work Hours Optimization")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bobby")
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bill")

# Set the objective function
m.setObjective(5*x0 + 7*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14.16*x0 + 5.77*x1 >= 8, "work_quality_min")
m.addConstr(-4*x0 + 5*x1 >= 0, "balance_hours")
m.addConstr(14.16*x0 + 5.77*x1 <= 39, "work_quality_max")
# Considering the equality for optimization purposes
m.addConstr(14.16*x0 + 5.77*x1 == 39, "work_quality_exact")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bobby: {x0.x}")
    print(f"Hours worked by Bill: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
