
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    bobby_hours = model.addVar(name="bobby_hours", integer=True)  # Integer constraint for Bobby
    bill_hours = model.addVar(name="bill_hours", integer=True)  # Integer constraint for Bill

    # Objective function: Maximize 5 * bobby_hours + 7 * bill_hours
    model.setObjective(5 * bobby_hours + 7 * bill_hours, gurobi.GRB.MAXIMIZE)

    # Constraints
    bobby_rating = 14.16
    bill_rating = 5.77

    # Constraint: Combined work quality rating >= 8
    model.addConstr(bobby_rating * bobby_hours + bill_rating * bill_hours >= 8)

    # Constraint: Combined work quality rating <= 39
    model.addConstr(bobby_rating * bobby_hours + bill_rating * bill_hours <= 39)

    # Constraint: -4 * bobby_hours + 5 * bill_hours >= 0
    model.addConstr(-4 * bobby_hours + 5 * bill_hours >= 0)

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Bobby hours: {bobby_hours.varValue}")
        print(f"Bill hours: {bill_hours.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
