
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
cheeseburgers = m.addVar(vtype=GRB.INTEGER, name="cheeseburgers")
tomatoes = m.addVar(vtype=GRB.CONTINUOUS, name="tomatoes")
milkshakes = m.addVar(vtype=GRB.INTEGER, name="milkshakes")

# Set objective function
m.setObjective(cheeseburgers**2 + cheeseburgers * milkshakes + 9 * tomatoes**2 + 4 * milkshakes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * cheeseburgers + 1 * tomatoes + 11 * milkshakes <= 66, "c0")  # Calcium upper bound
m.addConstr(7 * cheeseburgers + 6 * tomatoes + 2 * milkshakes <= 55, "c1")  # Fiber upper bound
m.addConstr(2 * cheeseburgers + 3 * tomatoes + 9 * milkshakes <= 62, "c2")  # Fat upper bound

m.addConstr(6 * tomatoes + 2 * milkshakes >= 15, "c3")  # Fiber from tomatoes and milkshakes
m.addConstr(1 * tomatoes + 11 * milkshakes <= 46, "c4")  # Calcium from tomatoes and milkshakes
m.addConstr(12 * cheeseburgers + 1 * tomatoes <= 25, "c5")  # Calcium from cheeseburgers and tomatoes
m.addConstr(12 * cheeseburgers + 1 * tomatoes + 11 * milkshakes <= 25, "c6")  # Calcium from all three
m.addConstr(7 * cheeseburgers + 6 * tomatoes <= 23, "c7")  # Fiber from cheeseburgers and tomatoes
m.addConstr(7 * cheeseburgers + 2 * milkshakes <= 41, "c8")  # Fiber from cheeseburgers and milkshakes
m.addConstr(7 * cheeseburgers**2 + 6 * tomatoes**2 + 2 * milkshakes**2 <= 21, "c9")  # Fiber squared
m.addConstr(7 * cheeseburgers + 6 * tomatoes + 2 * milkshakes <= 21, "c10")  # Fiber from all three
m.addConstr(2 * cheeseburgers + 3 * tomatoes <= 44, "c11")  # Fat from cheeseburgers and tomatoes
m.addConstr(3 * tomatoes**2 + 9 * milkshakes**2 <= 20, "c12")  # Fat squared from tomatoes and milkshakes
m.addConstr(2 * cheeseburgers**2 + 3 * tomatoes**2 + 9 * milkshakes**2 <= 28, "c13")  # Fat squared from all three
m.addConstr(2 * cheeseburgers + 3 * tomatoes + 9 * milkshakes <= 28, "c14")  # Fat from all three


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('cheeseburgers:', cheeseburgers.x)
    print('tomatoes:', tomatoes.x)
    print('milkshakes:', milkshakes.x)
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

