
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the decision variables
cheeseburgers = m.addVar(vtype=GRB.INTEGER, name="cheeseburgers")
tomatoes = m.addVar(vtype=GRB.CONTINUOUS, name="tomatoes")
milkshakes = m.addVar(vtype=GRB.INTEGER, name="milkshakes")

# Objective function
m.setObjective(1 * cheeseburgers**2 + 1 * cheeseburgers * milkshakes + 9 * tomatoes**2 + 4 * milkshakes, GRB.MAXIMIZE)

# Constraints
m.addConstr(12 * cheeseburgers <= 66, "calcium_cheeseburgers")
m.addConstr(7 * cheeseburgers <= 55, "fiber_cheeseburgers")
m.addConstr(2 * cheeseburgers <= 62, "fat_cheeseburgers")

m.addConstr(1 * tomatoes + 11 * milkshakes <= 46, "calcium_tomatoes_milkshakes")
m.addConstr(6 * tomatoes + 2 * milkshakes >= 15, "fiber_tomatoes_milkshakes")

m.addConstr(12 * cheeseburgers + 1 * tomatoes <= 25, "calcium_cheeseburgers_tomatoes")
m.addConstr(12 * cheeseburgers + 1 * tomatoes + 11 * milkshakes <= 25, "calcium_all")

m.addConstr(7 * cheeseburgers + 6 * tomatoes <= 23, "fiber_cheeseburgers_tomatoes")
m.addConstr(7 * cheeseburgers + 2 * milkshakes <= 41, "fiber_cheeseburgers_milkshakes")
m.addConstr(7 * cheeseburgers + 6 * tomatoes + 2 * milkshakes <= 21, "fiber_all")

m.addConstr(2 * cheeseburgers + 3 * tomatoes <= 44, "fat_cheeseburgers_tomatoes")
m.addConstr(3 * tomatoes**2 + 9 * milkshakes**2 <= 20, "fat_tomatoes_milkshakes_squared")
m.addConstr(2 * cheeseburgers**2 + 3 * tomatoes**2 + 9 * milkshakes**2 <= 28, "fat_all_squared")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cheeseburgers: {cheeseburgers.x}")
    print(f"Tomatoes: {tomatoes.x}")
    print(f"Milkshakes: {milkshakes.x}")
else:
    print("No optimal solution found")
