
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    cheeseburgers = model.addVar(name="cheeseburgers", vtype=gurobi.GRB.INTEGER)
    tomatoes = model.addVar(name="tomatoes")
    milkshakes = model.addVar(name="milkshakes", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(cheeseburgers**2 + cheeseburgers * milkshakes + 9 * tomatoes**2 + 4 * milkshakes, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * tomatoes + 2 * milkshakes >= 15)  # Fiber from tomatoes and milkshakes
    model.addConstr(tomatoes + 11 * milkshakes <= 46)  # Calcium from tomatoes and milkshakes
    model.addConstr(12 * cheeseburgers + tomatoes <= 25)  # Calcium from cheeseburgers and tomatoes
    model.addConstr(12 * cheeseburgers + tomatoes + 11 * milkshakes <= 25)  # Total calcium
    model.addConstr(7 * cheeseburgers + 6 * tomatoes <= 23)  # Fiber from cheeseburgers and tomatoes
    model.addConstr(7 * cheeseburgers + 2 * milkshakes <= 41)  # Fiber from cheeseburgers and milkshakes
    model.addConstr(cheeseburgers**2 + tomatoes**2 + milkshakes**2 <= 21)  # Fiber from squares
    model.addConstr(7 * cheeseburgers + 6 * tomatoes + 2 * milkshakes <= 21)  # Fiber from sum
    model.addConstr(2 * cheeseburgers + 3 * tomatoes <= 44)  # Fat from cheeseburgers and tomatoes
    model.addConstr(9 * tomatoes**2 + 81 * milkshakes**2 <= 20)  # Fat from squares of tomatoes and milkshakes
    model.addConstr(4 * cheeseburgers**2 + 9 * tomatoes**2 + 81 * milkshakes**2 <= 28)  # Fat from squares
    model.addConstr(2 * cheeseburgers + 3 * tomatoes + 9 * milkshakes <= 28)  # Fat from sum

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Cheeseburgers: ", cheeseburgers.varValue)
        print("Tomatoes: ", tomatoes.varValue)
        print("Milkshakes: ", milkshakes.varValue)
    else:
        print("Model is infeasible")

optimization_problem()
