
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Labor Cost")

# Define decision variables
ringo = model.addVar(vtype=GRB.INTEGER, name="ringo")
hank = model.addVar(vtype=GRB.INTEGER, name="hank")
bill = model.addVar(vtype=GRB.INTEGER, name="bill")
jean = model.addVar(vtype=GRB.INTEGER, name="jean")
george = model.addVar(vtype=GRB.INTEGER, name="george")
peggy = model.addVar(vtype=GRB.INTEGER, name="peggy")
john = model.addVar(vtype=GRB.INTEGER, name="john")
mary = model.addVar(vtype=GRB.INTEGER, name="mary")

# Set objective function
model.setObjective(7*ringo + 4*hank + 9*bill + 5*jean + 4*george + 3*peggy + 8*john + 6*mary, GRB.MINIMIZE)

# Add constraints
model.addConstr(8*bill + 6*jean >= 28)
model.addConstr(14*ringo + 6*jean >= 24)
model.addConstr(14*ringo + 2*mary >= 11)
model.addConstr(8*john + 2*mary >= 21)
model.addConstr(18*hank + 8*bill >= 17)
model.addConstr(6*jean + 17*george >= 12)
model.addConstr(14*ringo + 17*george >= 31)
model.addConstr(17*george + 13*peggy >= 17)
model.addConstr(8*bill + 8*john >= 13)
model.addConstr(14*ringo + 18*hank + 8*bill + 6*jean + 17*george + 13*peggy + 8*john + 2*mary >= 13)
model.addConstr(-10*jean + 3*mary >= 0)
model.addConstr(-2*john + 8*mary >= 0)
model.addConstr(-1*bill + 1*george >= 0)
model.addConstr(6*jean + 17*george <= 122)
model.addConstr(6*jean + 8*john <= 55)
model.addConstr(8*bill + 8*john <= 72)
model.addConstr(14*ringo + 6*jean <= 191)
model.addConstr(14*ringo + 2*mary <= 103)
model.addConstr(18*hank + 2*mary <= 153)
model.addConstr(8*bill + 13*peggy <= 84)
model.addConstr(8*bill + 13*peggy + 8*john <= 187)
model.addConstr(18*hank + 6*jean + 2*mary <= 95)
model.addConstr(6*jean + 8*john + 2*mary <= 131)
model.addConstr(14*ringo + 6*jean + 13*peggy <= 201)
model.addConstr(14*ringo + 6*jean + 8*john <= 87)
model.addConstr(17*george + 13*peggy + 8*john <= 88)
model.addConstr(18*hank + 8*john + 2*mary <= 124)
model.addConstr(14*ringo + 18*hank + 17*george <= 108)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}.")

