
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
R = m.addVar(name="Ringo", vtype=gp.GRB.INTEGER)
H = m.addVar(name="Hank", vtype=gp.GRB.INTEGER)
B = m.addVar(name="Bill", vtype=gp.GRB.INTEGER)
J = m.addVar(name="Jean", vtype=gp.GRB.INTEGER)
G = m.addVar(name="George", vtype=gp.GRB.INTEGER)
P = m.addVar(name="Peggy", vtype=gp.GRB.INTEGER)
Jo = m.addVar(name="John", vtype=gp.GRB.INTEGER)
M = m.addVar(name="Mary", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(7*R + 4*H + 9*B + 5*J + 4*G + 3*P + 8*Jo + 6*M, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8*J + 8*B >= 28)
m.addConstr(14*R + 6*J >= 24)
m.addConstr(14*R + 2*M >= 11)
m.addConstr(8*Jo + 2*M >= 21)
m.addConstr(18*H + 8*B >= 17)
m.addConstr(6*J + 17*G >= 12)
m.addConstr(14*R + 17*G >= 31)
m.addConstr(17*G + 13*P >= 17)
m.addConstr(8*B + 8*Jo >= 13)
m.addConstr(R + H + B + J + G + P + Jo + M >= 13)
m.addConstr(-10*J + 3*M >= 0)
m.addConstr(-2*Jo + 8*M >= 0)
m.addConstr(-B + G >= 0)
m.addConstr(6*J + 17*G <= 122)
m.addConstr(6*J + 8*Jo <= 55)
m.addConstr(8*B + 8*Jo <= 72)
m.addConstr(14*R + 6*J <= 191)
m.addConstr(14*R + 2*M <= 103)
m.addConstr(18*H + 2*M <= 153)
m.addConstr(8*B + 13*P <= 84)
m.addConstr(8*B + 13*P + 8*Jo <= 187)
m.addConstr(18*H + 6*J + 2*M <= 95)
m.addConstr(6*J + 8*Jo + 6*M <= 131)
m.addConstr(14*R + 6*J + 13*P <= 201)
m.addConstr(14*R + 6*J + 8*Jo <= 87)
m.addConstr(17*G + 13*P + 8*Jo <= 88)
m.addConstr(18*H + 8*Jo + 6*M <= 124)
m.addConstr(14*R + 18*H + 17*G <= 108)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Ringo: ", R.varValue)
    print("Hank: ", H.varValue)
    print("Bill: ", B.varValue)
    print("Jean: ", J.varValue)
    print("George: ", G.varValue)
    print("Peggy: ", P.varValue)
    print("John: ", Jo.varValue)
    print("Mary: ", M.varValue)
else:
    print("The model is infeasible")
