
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
kiwis = m.addVar(lb=0, name="kiwis")
ravioli = m.addVar(lb=0, vtype=GRB.INTEGER, name="ravioli")
chicken_breasts = m.addVar(lb=0, vtype=GRB.INTEGER, name="chicken_breasts")
eggs = m.addVar(lb=0, vtype=GRB.INTEGER, name="eggs")

# Set objective function
m.setObjective(9.26 * kiwis * ravioli + 3.05 * ravioli * ravioli + 6.13 * ravioli * chicken_breasts + 6.89 * chicken_breasts * eggs + 1.11 * kiwis + 4.88 * ravioli + 2.9 * eggs, GRB.MINIMIZE)

# Add constraints
m.addConstr(17.32 * ravioli + 11.73 * eggs >= 27, "c1")
m.addConstr(20.28 * kiwis * kiwis + 17.32 * ravioli * ravioli >= 43, "c2")
m.addConstr(20.28 * kiwis + 6.53 * chicken_breasts + 11.73 * eggs >= 36, "c3")
m.addConstr(20.28 * kiwis*kiwis + 17.32 * ravioli*ravioli + 6.53 * chicken_breasts*chicken_breasts >= 36, "c4")
m.addConstr(20.28 * kiwis + 6.53 * chicken_breasts + 11.73 * eggs >= 37, "c5")
m.addConstr(20.28 * kiwis + 17.32 * ravioli + 6.53 * chicken_breasts >= 37, "c6")
m.addConstr(20.28 * kiwis + 17.32 * ravioli + 6.53 * chicken_breasts + 11.73 * eggs >= 37, "c7")
m.addConstr(2.43 * chicken_breasts*chicken_breasts + 16.76 * eggs*eggs >= 113, "c8")
m.addConstr(14.99 * kiwis + 2.43 * chicken_breasts >= 57, "c9")
m.addConstr(14.99 * kiwis*kiwis + 16.76 * eggs*eggs >= 88, "c10")
m.addConstr(1.83 * ravioli + 16.76 * eggs >= 62, "c11")
m.addConstr(14.99 * kiwis + 1.83 * ravioli + 2.43 * chicken_breasts + 16.76 * eggs >= 62, "c12")
m.addConstr(18.86 * kiwis + 17.25 * ravioli >= 114, "c13")
m.addConstr(17.25 * ravioli + 7.38 * chicken_breasts >= 85, "c14")
m.addConstr(18.86 * kiwis*kiwis + 2.54 * eggs*eggs >= 132, "c15")
m.addConstr(18.86 * kiwis + 17.25 * ravioli + 7.38 * chicken_breasts + 2.54 * eggs >= 132, "c16")
m.addConstr(20.36 * kiwis + 6.39 * ravioli >= 71, "c17")
m.addConstr(20.36 * kiwis*kiwis + 7.12 * chicken_breasts*chicken_breasts >= 78, "c18")
m.addConstr(20.36 * kiwis*kiwis + 1.23 * eggs*eggs >= 45, "c19")
m.addConstr(7.12 * chicken_breasts + 1.23 * eggs >= 102, "c20")
m.addConstr(6.39 * ravioli + 7.12 * chicken_breasts >= 91, "c21")
m.addConstr(6.39 * ravioli + 1.23 * eggs >= 41, "c22")
m.addConstr(20.36 * kiwis + 6.39 * ravioli + 7.12 * chicken_breasts + 1.23 * eggs >= 41, "c23")
m.addConstr(5.32 * ravioli*ravioli + 7.03 * eggs*eggs >= 30, "c24")
m.addConstr(7.87 * kiwis + 5.32 * ravioli >= 41, "c25")
m.addConstr(4.97 * chicken_breasts + 7.03 * eggs >= 61, "c26")
m.addConstr(7.87 * kiwis + 4.97 * chicken_breasts >= 68, "c27")
m.addConstr(7.87 * kiwis*kiwis + 7.03 * eggs*eggs >= 46, "c28")
m.addConstr(7.87 * kiwis + 5.32 * ravioli + 4.97 * chicken_breasts + 7.03 * eggs >= 46, "c29")
m.addConstr(-2 * ravioli*ravioli + 8 * eggs*eggs >= 0, "c30")
m.addConstr(-1 * ravioli + 3 * chicken_breasts >= 0, "c31")
m.addConstr(17.32 * ravioli + 11.73 * eggs <= 57, "c32")
m.addConstr(20.28 * kiwis + 17.32 * ravioli <= 92, "c33")
m.addConstr(14.99 * kiwis + 16.76 * eggs <= 520, "c34")
m.addConstr(2.43 * chicken_breasts*chicken_breasts + 16.76 * eggs*eggs <= 237, "c35")
m.addConstr(14.99 * kiwis + 1.83 * ravioli <= 276, "c36")
m.addConstr(18.86 * kiwis + 7.38 * chicken_breasts <= 315, "c37")
m.addConstr(18.86 * kiwis + 2.54 * eggs <= 521, "c38")
m.addConstr(18.86 * kiwis + 17.25 * ravioli + 2.54 * eggs <= 269, "c39")
m.addConstr(18.86 * kiwis + 17.25 * ravioli + 7.38 * chicken_breasts <= 496, "c40")
m.addConstr(18.86 * kiwis*kiwis + 7.38 * chicken_breasts*chicken_breasts + 2.54 * eggs*eggs <= 149, "c41")
m.addConstr(17.25 * ravioli*ravioli + 7.38 * chicken_breasts*chicken_breasts + 2.54 * eggs*eggs <= 559, "c42")
m.addConstr(20.36 * kiwis*kiwis + 7.12 * chicken_breasts*chicken_breasts <= 309, "c43")
m.addConstr(5.32 * ravioli + 4.97 * chicken_breasts + 7.03 * eggs <= 94, "c44")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
else:
    print("Infeasible or unbounded")

