
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
b12 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="B12")
d = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="D")
c = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="C")

# Set objective function
model.setObjective(9.26 * b12 + 9.94 * d + 6.7 * c, GRB.MAXIMIZE)

# Add constraints
model.addConstr(d + 7 * c >= 31, "c1")
model.addConstr(-5 * d + 6 * c >= 0, "c2")
model.addConstr(b12 + 7 * c <= 130, "c3")
model.addConstr(b12 + d <= 71, "c4")
model.addConstr(b12 + d + 7 * c <= 174, "c5")  # Using the provided upper bound


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"B12: {b12.x}")
    print(f"D: {d.x}")
    print(f"C: {c.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

