
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Create variables
x0 = m.addVar(lb=0, name="milligrams_of_vitamin_B12", vtype=GRB.CONTINUOUS)
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_D", vtype=GRB.CONTINUOUS)
x2 = m.addVar(lb=0, name="milligrams_of_vitamin_C", vtype=GRB.CONTINUOUS)

# Set the objective function
m.setObjective(9.26*x0 + 9.94*x1 + 6.7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x0 + x1 + 7*x2 >= 31, name="cognitive_performance_index_min")
m.addConstr(-5*x1 + 6*x2 >= 0, name="vitamin_D_and_C_constraint")
m.addConstr(x0 + 7*x2 <= 130, name="vitamin_B12_and_C_max")
m.addConstr(x0 + x1 <= 71, name="vitamin_B12_and_D_max")
m.addConstr(x0 + x1 + 7*x2 <= 71, name="total_cognitive_performance_index_max")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
