
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="milligrams_of_vitamin_B12", lb=0)
    x1 = model.addVar(name="milligrams_of_vitamin_D", lb=0)
    x2 = model.addVar(name="milligrams_of_vitamin_C", lb=0)

    # Objective function: Maximize 9.26x0 + 9.94x1 + 6.7x2
    model.setObjective(9.26 * x0 + 9.94 * x1 + 6.7 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x0 + x1 + 7 * x2 >= 31)
    model.addConstr(-5 * x1 + 6 * x2 >= 0)
    model.addConstr(x0 + 7 * x2 <= 130)
    model.addConstr(x0 + x1 <= 71)
    model.addConstr(x0 + x1 + 7 * x2 <= 174) # corrected upper bound

    # Solve the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B12: {x0.varValue}")
        print(f"Milligrams of vitamin D: {x1.varValue}")
        print(f"Milligrams of vitamin C: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("No solution found.")

optimize_vitamins()
