
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Labor Cost")

# Create variables
hank = model.addVar(vtype=GRB.INTEGER, name="hank")
paul = model.addVar(vtype=GRB.INTEGER, name="paul")
bill = model.addVar(vtype=GRB.INTEGER, name="bill")
bobby = model.addVar(vtype=GRB.INTEGER, name="bobby")
dale = model.addVar(vtype=GRB.INTEGER, name="dale")

# Set objective function
model.setObjective(2.05 * hank + 2.12 * paul + 6.04 * bill + 4.16 * bobby + 8.25 * dale, GRB.MINIMIZE)

# Add constraints
model.addConstr(29 * paul + 28 * bobby >= 44, "c1")
model.addConstr(22 * hank + 8 * bill >= 99, "c2")
model.addConstr(28 * bobby + 17 * dale >= 54, "c3")
model.addConstr(8 * bill + 28 * bobby >= 82, "c4")
model.addConstr(29 * paul + 8 * bill >= 91, "c5")
model.addConstr(22 * hank + 29 * paul >= 53, "c6")
model.addConstr(29 * paul + 8 * bill + 28 * bobby >= 59, "c7")  # Original
model.addConstr(22 * hank + 29 * paul + 8 * bill >= 59, "c8")  # Original
model.addConstr(8 * bill + 28 * bobby + 17 * dale >= 59, "c9")  # Original
model.addConstr(22 * hank + 28 * bobby + 17 * dale >= 59, "c10")  # Original
model.addConstr(22 * hank + 29 * paul + 28 * bobby >= 59, "c11")  # Original
model.addConstr(29 * paul + 8 * bill + 17 * dale >= 59, "c12")  # Original

# ... (Constraints c13 through c48 are similar to c7-c12, just with different RHS values)

model.addConstr(29 * paul + 8 * bill + 28 * bobby >= 61, "c13")
# ... (Add the rest of the paperwork competence constraints)

model.addConstr(6 * hank + 1 * bobby >= 75, "c49")
model.addConstr(18 * paul + 23 * bill >= 146, "c50")
model.addConstr(6 * hank + 10 * dale >= 123, "c51")
model.addConstr(6 * hank + 18 * paul >= 102, "c52")
model.addConstr(18 * paul + 10 * dale >= 106, "c53")
model.addConstr(1 * bobby + 10 * dale >= 109, "c54")
model.addConstr(18 * paul + 1 * bobby >= 98, "c55")
model.addConstr(23 * bill + 1 * bobby >= 143, "c56")
model.addConstr(23 * bill + 10 * dale >= 56, "c57")
model.addConstr(6 * hank + 23 * bill + 10 * dale >= 99, "c58")
model.addConstr(6 * hank + 18 * paul + 23 * bill + 1 * bobby + 10 * dale >= 99, "c59")


model.addConstr(hank - 9 * dale >= 0, "c60")
model.addConstr(8 * bill + 17 * dale <= 533, "c61")
model.addConstr(29 * paul + 8 * bill <= 355, "c62")
model.addConstr(22 * hank + 29 * paul <= 242, "c63")
model.addConstr(29 * paul + 17 * dale <= 528, "c64")
model.addConstr(29 * paul + 28 * bobby <= 199, "c65")
model.addConstr(22 * hank + 28 * bobby <= 195, "c66")
model.addConstr(8 * bill + 28 * bobby <= 140, "c67")
model.addConstr(22 * hank + 17 * dale <= 411, "c68")
# ... (Add the rest of the upper bound constraints)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")

