
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
hours_worked_by_Hank = m.addVar(name="Hank", vtype=gp.GRB.INTEGER)
hours_worked_by_Paul = m.addVar(name="Paul", vtype=gp.GRB.INTEGER)
hours_worked_by_Bill = m.addVar(name="Bill", vtype=gp.GRB.INTEGER)
hours_worked_by_Bobby = m.addVar(name="Bobby", vtype=gp.GRB.INTEGER)
hours_worked_by_Dale = m.addVar(name="Dale", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(2.05 * hours_worked_by_Hank + 2.12 * hours_worked_by_Paul + 
               6.04 * hours_worked_by_Bill + 4.16 * hours_worked_by_Bobby + 
               8.25 * hours_worked_by_Dale, gp.GRB.MINIMIZE)

# Individual competence ratings
m.addConstraint(hours_worked_by_Hank * 22 <= 542)
m.addConstraint(hours_worked_by_Hank * 6 <= 737)
m.addConstraint(hours_worked_by_Paul * 29 <= 542)
m.addConstraint(hours_worked_by_Paul * 18 <= 737)
m.addConstraint(hours_worked_by_Bill * 8 <= 542)
m.addConstraint(hours_worked_by_Bill * 23 <= 737)
m.addConstraint(hours_worked_by_Bobby * 28 <= 542)
m.addConstraint(hours_worked_by_Bobby * 1 <= 737)
m.addConstraint(hours_worked_by_Dale * 17 <= 542)
m.addConstraint(hours_worked_by_Dale * 10 <= 737)

# Combined paperwork constraints
m.addConstraint(hours_worked_by_Paul * 29 + hours_worked_by_Bobby * 28 >= 44)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Bill * 8 >= 99)
m.addConstraint(hours_worked_by_Bobby * 28 + hours_worked_by_Dale * 17 >= 54)
m.addConstraint(hours_worked_by_Bill * 8 + hours_worked_by_Bobby * 28 >= 82)
m.addConstraint(hours_worked_by_Paul * 29 + hours_worked_by_Bill * 8 >= 91)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Paul * 29 >= 53)
m.addConstraint(hours_worked_by_Paul * 29 + hours_worked_by_Bill * 8 + hours_worked_by_Bobby * 28 >= 59)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Paul * 29 + hours_worked_by_Bill * 8 >= 59)
m.addConstraint(hours_worked_by_Bill * 8 + hours_worked_by_Bobby * 28 + hours_worked_by_Dale * 17 >= 59)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Bobby * 28 + hours_worked_by_Dale * 17 >= 59)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Paul * 29 + hours_worked_by_Bobby * 28 >= 59)
m.addConstraint(hours_worked_by_Paul * 29 + hours_worked_by_Bill * 8 + hours_worked_by_Dale * 17 >= 59)
m.addConstraint(hours_worked_by_Paul * 29 + hours_worked_by_Bill * 8 + hours_worked_by_Bobby * 28 >= 61)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Paul * 29 + hours_worked_by_Bill * 8 >= 61)
m.addConstraint(hours_worked_by_Bill * 8 + hours_worked_by_Bobby * 28 + hours_worked_by_Dale * 17 >= 61)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Bobby * 28 + hours_worked_by_Dale * 17 >= 61)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Paul * 29 + hours_worked_by_Bobby * 28 >= 61)
m.addConstraint(hours_worked_by_Paul * 29 + hours_worked_by_Bill * 8 + hours_worked_by_Dale * 17 >= 61)
m.addConstraint(hours_worked_by_Paul * 29 + hours_worked_by_Bill * 8 + hours_worked_by_Bobby * 28 >= 79)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Paul * 29 + hours_worked_by_Bill * 8 >= 79)
m.addConstraint(hours_worked_by_Bill * 8 + hours_worked_by_Bobby * 28 + hours_worked_by_Dale * 17 >= 79)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Bobby * 28 + hours_worked_by_Dale * 17 >= 79)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Paul * 29 + hours_worked_by_Bobby * 28 >= 79)
m.addConstraint(hours_worked_by_Paul * 29 + hours_worked_by_Bill * 8 + hours_worked_by_Dale * 17 >= 79)

# Combined computer constraints
m.addConstraint(hours_worked_by_Hank * 6 + hours_worked_by_Bobby * 1 >= 75)
m.addConstraint(hours_worked_by_Paul * 18 + hours_worked_by_Bill * 23 >= 146)
m.addConstraint(hours_worked_by_Hank * 6 + hours_worked_by_Dale * 10 >= 123)
m.addConstraint(hours_worked_by_Hank * 6 + hours_worked_by_Paul * 18 >= 102)
m.addConstraint(hours_worked_by_Paul * 18 + hours_worked_by_Dale * 10 >= 106)
m.addConstraint(hours_worked_by_Bobby * 1 + hours_worked_by_Dale * 10 >= 109)
m.addConstraint(hours_worked_by_Paul * 18 + hours_worked_by_Bobby * 1 >= 98)
m.addConstraint(hours_worked_by_Bill * 23 + hours_worked_by_Bobby * 1 >= 143)
m.addConstraint(hours_worked_by_Bill * 23 + hours_worked_by_Dale * 10 >= 56)
m.addConstraint(hours_worked_by_Hank * 6 + hours_worked_by_Bill * 23 + hours_worked_by_Dale * 10 >= 99)

# Other constraints
m.addConstraint(hours_worked_by_Hank - 9 * hours_worked_by_Dale >= 0)
m.addConstraint(hours_worked_by_Bill * 8 + hours_worked_by_Dale * 17 <= 533)
m.addConstraint(hours_worked_by_Paul * 29 + hours_worked_by_Bill * 8 <= 355)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Paul * 29 <= 242)
m.addConstraint(hours_worked_by_Paul * 29 + hours_worked_by_Dale * 17 <= 528)
m.addConstraint(hours_worked_by_Paul * 29 + hours_worked_by_Bobby * 28 <= 199)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Bobby * 28 <= 195)
m.addConstraint(hours_worked_by_Bill * 8 + hours_worked_by_Bobby * 28 <= 140)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Dale * 17 <= 411)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Bill * 8 + hours_worked_by_Bobby * 28 <= 518)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Paul * 29 + hours_worked_by_Bobby * 28 <= 539)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Paul * 29 + hours_worked_by_Bill * 8 <= 260)
m.addConstraint(hours_worked_by_Hank * 22 + hours_worked_by_Paul * 29 + hours_worked_by_Dale * 17 <= 265)
m.addConstraint(hours_worked_by_Paul * 29 + hours_worked_by_Bill * 8 + hours_worked_by_Dale * 17 <= 387)
m.addConstraint(hours_worked_by_Hank * 6 + hours_worked_by_Bill * 23 <= 593)
m.addConstraint(hours_worked_by_Paul * 18 + hours_worked_by_Bobby * 1 <= 392)
m.addConstraint(hours_worked_by_Hank * 6 + hours_worked_by_Bill * 23 + hours_worked_by_Bobby * 1 <= 558)
m.addConstraint(hours_worked_by_Paul * 18 + hours_worked_by_Bill * 23 + hours_worked_by_Bobby * 1 <= 589)
m.addConstraint(hours_worked_by_Paul * 18 + hours_worked_by_Bobby * 1 + hours_worked_by_Dale * 10 <= 513)

# Solve the problem
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Hank: {hours_worked_by_Hank.varValue}")
    print(f"Hours worked by Paul: {hours_worked_by_Paul.varValue}")
    print(f"Hours worked by Bill: {hours_worked_by_Bill.varValue}")
    print(f"Hours worked by Bobby: {hours_worked_by_Bobby.varValue}")
    print(f"Hours worked by Dale: {hours_worked_by_Dale.varValue}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
