
import gurobi as gp

m = gp.Model("optimization_problem")

x0 = m.addVar(name="hours_worked_by_Bill", lb=0)
x1 = m.addVar(name="hours_worked_by_Dale", lb=0)
x2 = m.addVar(name="hours_worked_by_John", lb=0)
x3 = m.addVar(name="hours_worked_by_Hank", lb=0)

m.setObjective(3*x0 + 8*x1 + 6*x2 + x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(7.1 * x0 <= 440)
m.addConstr(9.28 * x0 <= 306)
m.addConstr(4.65 * x0 <= 243)
m.addConstr(3.94 * x0 <= 246)
m.addConstr(7.53 * x0 <= 520)

m.addConstr(9.48 * x1 <= 440)
m.addConstr(4.6 * x1 <= 306)
m.addConstr(9.13 * x1 <= 243)
m.addConstr(2.01 * x1 <= 246)
m.addConstr(2.29 * x1 <= 520)

m.addConstr(6.37 * x2 <= 440)
m.addConstr(3.61 * x2 <= 306)
m.addConstr(1.4 * x2 <= 243)
m.addConstr(3.3 * x2 <= 246)
m.addConstr(3.41 * x2 <= 520)

m.addConstr(3.21 * x3 <= 440)
m.addConstr(3.76 * x3 <= 306)
m.addConstr(4.87 * x3 <= 243)
m.addConstr(8.66 * x3 <= 246)
m.addConstr(5.1 * x3 <= 520)

m.addConstr(9.48 * x1 + 3.21 * x3 >= 51)
m.addConstr(7.1 * x0 + 6.37 * x2 >= 65)
m.addConstr(6.37 * x2 + 3.21 * x3 >= 103)
m.addConstr(7.1 * x0 + 9.48 * x1 + 3.21 * x3 >= 60)
m.addConstr(4.6 * x1 + 3.76 * x3 >= 64)
m.addConstr(3.61 * x2 + 3.76 * x3 >= 41)
m.addConstr(9.28 * x0 + 3.61 * x2 >= 36)
m.addConstr(9.28 * x0 + 4.6 * x1 + 3.76 * x3 >= 51)
m.addConstr(4.65 * x0 + 9.13 * x1 >= 47)
m.addConstr(4.65 * x0 + 4.87 * x3 >= 52)
m.addConstr(3.94 * x0 + 8.66 * x3 >= 60)
m.addConstr(-9 * x0 + 5 * x2 + 4 * x3 >= 0)
m.addConstr(7.1 * x0 + 6.37 * x2 <= 388)
m.addConstr(7.1 * x0 + 9.48 * x1 <= 266)

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hours worked by Bill:", x0.varValue)
    print("Hours worked by Dale:", x1.varValue)
    print("Hours worked by John:", x2.varValue)
    print("Hours worked by Hank:", x3.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
