
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Labor Cost")

# Create variables
john_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="John_Hours")
bobby_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bobby_Hours")

# Set objective function
model.setObjective(9 * john_hours + 6 * bobby_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(1 * john_hours + 1 * bobby_hours >= 21, "Productivity_Lower_Bound")
model.addConstr(1 * john_hours + 1 * bobby_hours <= 56, "Productivity_Upper_Bound")
model.addConstr(6 * john_hours + 9 * bobby_hours >= 24, "Computer_Competence_Lower_Bound")
model.addConstr(6 * john_hours + 9 * bobby_hours <= 42, "Computer_Competence_Upper_Bound")
model.addConstr(-7 * john_hours + 4 * bobby_hours >= 0, "Additional_Constraint")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f"John's Hours: {john_hours.x}")
    print(f"Bobby's Hours: {bobby_hours.x}")
    print(f"Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print(f"Optimization ended with status {model.status}")

