
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_John")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")

# Set the objective function
m.setObjective(9*x0 + 6*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(x0 + x1 >= 21, "Combined_Productivity_Rating_Min")
m.addConstr(6*x0 + 9*x1 >= 24, "Combined_Computer_Competence_Rating_Min")
m.addConstr(-7*x0 + 4*x1 >= 0, "Constraint_1")
m.addConstr(x0 + x1 <= 56, "Combined_Productivity_Rating_Max")
m.addConstr(6*x0 + 9*x1 <= 42, "Combined_Computer_Competence_Rating_Max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by John:", x0.x)
    print("Hours worked by Bobby:", x1.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found")
