
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Define variables
hours_worked_by_John = model.addVar(name="hours_worked_by_John", lb=0)  # Assuming hours cannot be negative
hours_worked_by_Bobby = model.addVar(name="hours_worked_by_Bobby", lb=0)  # Assuming hours cannot be negative

# Objective function: Minimize 9 * hours_worked_by_John + 6 * hours_worked_by_Bobby
model.setObjective(9 * hours_worked_by_John + 6 * hours_worked_by_Bobby, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(hours_worked_by_John + hours_worked_by_Bobby >= 21, name="productivity_rating_constraint")
model.addConstr(6 * hours_worked_by_John + 9 * hours_worked_by_Bobby >= 24, name="computer_competence_rating_constraint")
model.addConstr(hours_worked_by_John + hours_worked_by_Bobby <= 56, name="productivity_upper_bound_constraint")
model.addConstr(6 * hours_worked_by_John + 9 * hours_worked_by_Bobby <= 42, name="computer_competence_upper_bound_constraint")
model.addConstr(-7 * hours_worked_by_John + 4 * hours_worked_by_Bobby >= 0, name="additional_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by John: {hours_worked_by_John.varValue}")
    print(f"Hours worked by Bobby: {hours_worked_by_Bobby.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
