
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
honeypots = m.addVar(vtype=gp.GRB.INTEGER, name="honeypots")
network_admins = m.addVar(vtype=gp.GRB.INTEGER, name="network_admins")
patches_per_day = m.addVar(vtype=gp.GRB.INTEGER, name="patches_per_day")

# Set objective function
m.setObjective(2.27 * honeypots + 8.46 * network_admins + 3.88 * patches_per_day, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * honeypots + 12 * patches_per_day >= 92, "data_accessibility_1")
m.addConstr(20 * honeypots + 4 * patches_per_day >= 84, "network_integrity_1")
m.addConstr(20 * honeypots + 12 * patches_per_day >= 38, "power_consumption_1")

m.addConstr(12 * honeypots + 12 * patches_per_day <= 216, "data_accessibility_2")
m.addConstr(12 * honeypots + 18 * network_admins <= 265, "data_accessibility_3")
m.addConstr(12 * honeypots + 18 * network_admins + 12 * patches_per_day <= 265, "data_accessibility_4")

m.addConstr(20 * honeypots + 20 * network_admins <= 175, "network_integrity_2")
m.addConstr(20 * network_admins + 4 * patches_per_day <= 132, "network_integrity_3")
m.addConstr(20 * honeypots + 4 * patches_per_day <= 131, "network_integrity_4")
m.addConstr(20 * honeypots + 20 * network_admins + 4 * patches_per_day <= 131, "network_integrity_5")


m.addConstr(12 * network_admins + 12 * patches_per_day <= 111, "power_consumption_2")
m.addConstr(20 * honeypots + 12 * network_admins <= 111, "power_consumption_3")
m.addConstr(20 * honeypots + 12 * network_admins + 12 * patches_per_day <= 115, "power_consumption_4")
# Redundant constraint - Removing for efficiency
# m.addConstr(20 * honeypots + 12 * network_admins + 12 * patches_per_day <= 115, "power_consumption_5")


# Resource Constraints based on provided dictionary (Redundant given the individual constraints already defined - Keeping them commented out)
# m.addConstr(12 * honeypots + 18 * network_admins + 12 * patches_per_day <= 348, "r0_data_accessibility")
# m.addConstr(20 * honeypots + 20 * network_admins + 4 * patches_per_day <= 260, "r1_network_integrity")
# m.addConstr(20 * honeypots + 12 * network_admins + 12 * patches_per_day <= 116, "r2_power_consumption")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('honeypots:', honeypots.x)
    print('network_admins:', network_admins.x)
    print('patches_per_day:', patches_per_day.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
